/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#ifndef _UDM_DBMS_H
#define _UDM_DBMS_H

#include "udm_search_tl.h"	/* Because of stl_info_t */

/* Database type */
#define UDM_DB_UNK			0
#define UDM_DB_MSQL			1
#define UDM_DB_MYSQL			2
#define UDM_DB_PGSQL			3
#define UDM_DB_SOLID			4
#define UDM_DB_VIRT			6
#define UDM_DB_IBASE			7
#define UDM_DB_ORACLE8			8
#define UDM_DB_ORACLE7			9
#define UDM_DB_MSSQL			10
#define UDM_DB_SAPDB			11
#define UDM_DB_DB2			12
#define UDM_DB_FILES			100
#define UDM_DB_SEARCHD			200


#define UDM_URL_ACTION_DELETE		1
#define UDM_URL_ACTION_ADD		2
#define UDM_URL_ACTION_SUPDATE		3
#define UDM_URL_ACTION_LUPDATE		4
#define UDM_URL_ACTION_INSWORDS		5
#define UDM_URL_ACTION_INSCWORDS	6
#define UDM_URL_ACTION_DELWORDS		7
#define UDM_URL_ACTION_DELCWORDS	8
#define UDM_URL_ACTION_UPDCLONE		9
#define UDM_URL_ACTION_REGCHILD		10
#define UDM_URL_ACTION_FINDBYURL	11
#define UDM_URL_ACTION_FINDBYMSG	12
#define UDM_URL_ACTION_FINDORIG		13
#define UDM_URL_ACTION_EXPIRE		14
#define UDM_URL_ACTION_REFERERS		15
#define UDM_URL_ACTION_SERVERTABLE	17
#define UDM_URL_ACTION_DOCCOUNT		18
#define UDM_URL_ACTION_HTDBGET		19
#define UDM_URL_ACTION_FLUSH		20

#define UDM_RES_ACTION_WORDS		1
#define UDM_RES_ACTION_DOCINFO		2
#define UDM_RES_ACTION_TARGETS		3
#define UDM_RES_ACTION_INSWORDS		4

#define UDM_CAT_ACTION_PATH		1
#define UDM_CAT_ACTION_LIST		2

#define UDM_SRV_ACTION_TABLE		1

extern void	*UdmDBInit(void *db);
extern void	UdmDBFree(void *db);
extern int	UdmDBSetAddr(void *db,const char *addr,int mode);

extern __INDLIB__ int UdmURLAction(UDM_AGENT *A, UDM_DOCUMENT   *D, int cmd, void *db);
extern __INDLIB__ int UdmResAction(UDM_AGENT *A, UDM_RESULT     *R, int cmd, void *db);
extern __INDLIB__ int UdmCatAction(UDM_AGENT *A, UDM_CATEGORY   *C, int cmd, void *db);
extern __INDLIB__ int UdmSrvAction(UDM_AGENT *A, UDM_SERVERLIST *S, int cmd, void *db);
extern __INDLIB__ UDM_UINT8_URLID* UdmLimit8(UDM_AGENT *Agent,const char *field,int *count,int type,void *db);
extern __INDLIB__ UDM_UINT4_URLID* UdmLimit4(UDM_AGENT *Agent,const char *field,int *count,int type,void *db);

extern __INDLIB__ UDM_RESULT *UdmFind(UDM_AGENT *,const char * text);
extern __INDLIB__ int UdmClearDatabase(UDM_AGENT *A);
extern __INDLIB__ int UdmStatAction(UDM_AGENT *A, UDM_STATLIST *S);

extern UDM_DBLIST	*UdmDBListInit(UDM_DBLIST *List);
extern size_t		UdmDBListAdd(UDM_DBLIST *List,const char * addr);
extern void		UdmDBListFree(UDM_DBLIST *List);

#endif
